//******************************************
// file			: main.c
// version		: V1.0
// brief		: main program
// note			: UART transmit/receive example : transmit(TX) within polling, receive(RX) within interrupt(RX)
//****************************************** 
#ifndef	IO_MEM
#define	IO_MEM
#endif  
#include "MQ6811.h"


main()
{


	WDCDR.byte = 0x4e;	//clear WDT
    //=========================
	//set UART pin
	// 
	//=========================
	P9CR.bit.b1 = 0x0;  //p91 RX
	P9CR.bit.b0 = 0x1;
	P9FC.bit.b0 = 0x1;  //P90 TX
	
    //=========================
	//set IntRXD  IntTXD
	// 
	//=========================	
	__asm("DI");
	POFFCR1.byte = 0x02;	
	EIRE.byte = 0xC0;// INTTXD0:INTRXD0:INTTBT:INTWUC:Reserved:Reserved:Reserved:Interrupt-master-enableflag
	__asm("EI");
    //=========================
	//set uart config
	// 8,N,1 baudrate= 9600
	//=========================		
	UART1CR2.byte=0x00;	//Receive stop bit = 1
	UART1DR.byte = 0x0C;	//baud rate = 9600
	UART1CR1.byte = 0xc0;//Rx Tx enable,Transmit stop bit length=1,No parity,UART output,Transfer base clock=fcgck
      
	  
	while(1)
	{
		WDCDR.byte = 0x4e;	//clear WDT
		
	}	
    
}